#! /bin/bash
# Evaluate apache access log, extract new attackers ip address, retrieve wrapping network and add those to pf.badguys
# Reload firewall rules afterwards

if [ $# -ne 6 ] ; then
	echo "Script has to be called with 6 parameters:"
	echo "  Name of the log file, i.e. /var/log/apache2/access.log"
	echo "  Threshold for number of attacks for filtering, i.e. 5"
	echo "  Scope - either i (single ip addresses) or n (complete networks)"
	echo "  Look-back time (numeric) in hours or minutes, i.e. 20"
	echo "      followed by unit H | M (hours or minutes), i.e. M"
	echo "  Blocking duration: number (1-99) unit (d|h|m) for days|hours|minutes"
	echo "Sample call invocation:"
	echo "  /usr/local/sbin/upd_pf_from_http_log.sh /var/log/apache2/access.log 5 i 15 M 1d"
	echo "    -> Search /var/log/apache2/access.log, threshold set to 5, block single IP addresses only, lookback time set to -15 minutes, block for 1 day"
	echo "  /usr/local/sbin/upd_pf_from_http_log.sh /var/log/apache2/access.log 500 n 3 H 2h"
	echo "    -> Search /var/log/apache2/access.log, threshold set to 500, block complete networks, lookback time set to -3 hours block for 2 hours"
	echo "When automating this script using a launch daemon, launch interval has to be set accordingly to make sense."
	exit 4
fi

PID=$$
HOSTN=`uname -n|cut -d '.' -f 1`

LOGFILE=$1
THRESHOLD=$2
SCOPE=$3
LOOKBACK=$4
TUNIT=$5
DRATN=$6

if [ -f ${LOGFILE} ] ; then
	if [ ${SCOPE} != "i" -a ${SCOPE} != "n" ] ; then
		echo 'Scope invalid: not i or n. Terminating.'
		exit 4
	fi

	if [ ${TUNIT} == "H" -o ${TUNIT} == "M" ] ; then
		CHKSINCE=`date -v -${LOOKBACK}${TUNIT} +"%Y-%m-%d %H:%M:%S"`
	else
		echo 'Time unit not H (hours) or M (minutes). Terminating.'
		exit 5
	fi

	/usr/local/sbin/mini_weblog_crawler.pl /var/log/apache2/access_log ${THRESHOLD} "${CHKSINCE}" ${SCOPE} ${DRATN} s | cut -f 2 > /tmp/pf.badguys
	cat /tmp/pf.badguys /etc/pf.badguys | sort -h | uniq > /etc/pf.badguys
	pfctl -e -f /etc/pf.conf
	rm -rf /tmp/pf.badguys

	NUMBLCK=`cat /etc/pf.ip_register | wc -l`
	NUMBLCK=$(($NUMBLCK+0))
	TSTAMP=`date +"%Y-%m-%d %H:%M:%S"`
	if [ $NUMBLCK -eq 0 ] ; then
		echo "$TSTAMP $HOSTN mini_weblog_crawler[$PID], INFO, 0 ip addresses blocked." >> /var/log/mini_weblog_crawler.log
		logger -i -p daemon.warning "mini_weblog_crawler[$PID]: 0 ip addresses blocked."
	else
		while read LINE
			do LMSG="mini_weblog_crawler[$PID], WARNING, address blocked, msg=$LINE."
			echo "$TSTAMP $HOSTN $LMSG" >> /var/log/mini_weblog_crawler.log
			logger -i -p daemon.warning $LMSG
		done < /etc/pf.ip_register
	fi
else
	echo "Logfile ${LOGFILE} does not exist or is not accessible. Terminating."
	exit 12
fi

exit 0
