#! /bin/bash
# Uninstall the tiny private threat response for mac package
echo "uninstall_tPTR_mac.sh started."
echo " "

if [ `whoami` != 'root' ] ; then
	echo "Script not running with admin rights. Try 'sudo install_priv_threat_response_mac.sh' instead."
	exit 4
fi

# First stop the daemon and deactivate pf
echo -n "Stopping the daemon ... "
launchctl unload /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
echo "==> done"

# Deactivate pf, restore old config, activate pf again
echo -n "Reload pf with old pf.conf ... "
mv /etc/pf.conf.before_mini_webcrawler /etc/pf.conf
pfctl -e -f /etc/pf.conf
echo "==> done"

# Remove installed files from /usr/local/sbin
echo -n "Now removing all installed files in /usr/local/sbin/ ... "
rm -rf /usr/local/sbin/mini_weblog_crawler.pl
rm -rf /usr/local/sbin/upd_pf_from_http_log.sh
echo "==> done"

# Remove logfile
echo -n "Now removing log file /var/log/mini_weblog_crawler.log ... "
rm -rf /var/log/mini_weblog_crawler.log
echo "==> done"

# Remove installed files from /Library/LaunchDaemons/
echo -n "Now removing the launch daemon (plist) in /Library/LaunchDaemons/ ... "
rm -rf /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
echo "==> done"

# Remove /etc/pf.badguys and /etc/pf.ip_register
echo "Now removing pf table /etc/pf.badguys and IP register /etc/pf.ip_register..."
rm -rf /etc/pf.badguys
rm -rf /etc/pf.ip_register
echo "==> done"

# Remove all /etc/pf.ip_addresses.xx.lst files (goodguys)
echo "Now removing all /etc/pf.ip_addresses.xx.ist files (goodguys)..."
rm -rf ip_addresses.*.lst
echo "==> done"

echo "The tiny Private Threat Response tPTR is now removed from your system."

exit 0
