#! /bin/bash
# Install the tiny private threat response for mac package
echo "install_tPTR_mac.sh started."
echo " "

if [ `whoami` != 'root' ] ; then
	echo "Script not running with admin rights. Try 'sudo install_priv_threat_response_mac.sh' instead."
	exit 4
fi

# First of all create /usr/local/sbin and copy all *.pl and *.sh files to
if [ -d /usr/local/sbin ] ; then
	echo -n "Path '/usr/local/sbin' already existing ... ==> ok"
else
	echo -n "  Generating path '/usr/local/sbin' ... "
	mkdir /usr/local/sbin
	RC=$?
	if [ $RC -eq 0 ] ; then
		echo "==> done"
	else
		echo "failed. May be insufficient access rights ?"
		echo "Exiting."
		exit 8
	fi
fi

# Copy required files to /usr/local/sbin/
echo -n "Now copying mini_weblog_crawler and script to update firewall rules to /usr/local/sbin/ ... "
cp -v mini_weblog_crawler.pl /usr/local/sbin/
cp -v upd_pf_from_http_log.sh /usr/local/sbin
echo "==> done"

# Copy required file to /Library/LaunchDaemons/
echo -n "Now copying config file for launch daemon (plist) to /Library/LaunchDaemons/ ... "
cp local.upd_pf_from_http_log.plist /Library/LaunchDaemons/
echo "==> done"

# Generate empty /etc/pf.badguys and /etc/pf.ip_register
echo -n "Now generating empty /etc/pf.badguys..."
touch /etc/pf.badguys
touch /etc/pf.ip_register
echo "==> done"
echo " "

# Copy the goodguys files to /etc/
echo -n "Now copying the IP address lists for DE, AT and CH to /etc/..."
cp pf.ip_addresses.*.lst /etc/
echo "==> done"
echo " "

# Installation done so far. Now for the hints and edit steps
echo "Installation done."
echo " "
echo "To activate the following steps have to be executed manually:"
echo "   1 editing the firewalls' config file /etc/pf.conf"
echo "   2 adjusting the execution parameters for the mini_webcrawler in the plist"
echo "   3 launching the plist"
echo " "
echo "2) To adjust the execution parameters to something different"
echo "   you have to edit the file /Library/LaunchDaemons/local.upd_pf_from_http_log.plist."
echo "   The threshold value is set to the value of 5 in row 15, i.e. <string>5</string>,"
echo "   The look-back time is set to the value of 15 in row 16, i.e. <string>15</string> and"
echo "   The time unit is set to minutes (value of M) in row 17, i.e. <string>M</string>".
echo "   Whilst the first to parameters are to be set to any numeric value,"
echo "   the time unit (last parameter) can only be set to H (hours) or M (minutes)."
echo "   Adjustment can be done at any time later."
echo " "
echo "3) To launch the plist for the mini_weblog_crawler simply enter this command:"
echo " sudo launchctl load -w /Library/LaunchDaemons/local.upd_pf_from_http_log.plist"
echo " "

# Ask if to edit firewall conf file now
read -e -p "Do you want to edit he firewalls' config file /etc/pf.conf (v=vi | n=nano | t=TextEdit | anything else=no) ? "
if [ -z $REPLY ] ; then
	REPLY="no"
fi
ANSWER=$REPLY
if [ ! ${ANSWER} = "no" ] ; then
#	save original pf.conf
	echo -n "  Existing config file for pf will be saved ==> "
	cp /etc/pf.conf /etc/pf.conf.before_mini_webcrawler
	echo "done (/etc/pf.conf /etc/pf.conf.before_mini_webcrawler)"
	echo "  Now opening sample pf config file. You need to copy the 2nd half"
	echo "  to the original which will also be opened in preferred editor."
	echo "  In case of using TextEdit, windows may be put over each other."
	read -e -p "  (press ENTER to edit)"
#	open the sample file to show what to copy
	open -ne pf.conf.sample
fi

if [ ${ANSWER} = "v" ] ; then
	sudo -e /etc/pf.conf
	echo "File edited."
elif [ ${ANSWER} = "n" ] ; then
	sudo nano /etc/pf.conf
	echo "File edited."
elif [ ${ANSWER} = "t" ] ; then
# 	Adjust temporarily access rights for folder and file to allow TextEdit to work
	echo "Remind: End TextEdit session with CMD+Q. Do NOT close the window by red button!"
	read -e -p "(press ENTER to edit)"
	chgrp admin /etc/pf.conf
	chmod 664 /etc/pf.conf
		open -Wne /etc/pf.conf
# 	Restore access rights for folder and file to default
	chgrp wheel /etc/pf.conf
	chmod 644 /etc/pf.conf
	echo "File edited."
else
	echo "Firewall's config file /etc/pf.conf not edited as per request."
fi

# reload pf with new config if required
if [ ! ${ANSWER} = "no" ] ; then
	pfctl -e -f /etc/pf.conf
fi

# Ask if to edit execution parameters now
echo " "
read -e -p "Do you want to edit execution parameters (v=vi | n=nano | t=TextEdit | anything else=no) ? "
if [ -z $REPLY ] ; then
	REPLY="no"
fi
if [ ${REPLY} = "v" ] ; then
	sudo -e /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
	echo "File edited."
elif [ ${REPLY} = "n" ] ; then
	sudo nano /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
	echo "File edited."
elif [ ${REPLY} = "t" ] ; then
# 	Adjust temporarily access rights for folder and file to allow TextEdit to work
	echo "Remind: End TextEdit session with CMD+Q. Do NOT close the window by red button!"
	read -e -p "(press ENTER to edit)"
	chgrp admin /Library/LaunchDaemons
	chmod 775 /Library/LaunchDaemons/
		chgrp admin /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
		chmod 664 /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
			open -Wne /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
# 	Restore access rights for folder and file to default
		chgrp wheel /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
		chmod 644 /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
	chgrp wheel /Library/LaunchDaemons
	chmod 755 /Library/LaunchDaemons/
	echo "File edited."
else
	echo "Execution parameters not edited as per request."
fi

# Ask if to launch the mini_weblog_crawler
echo " "
read -e -p "Do you want me to launch the mini_weblog_crawler (yes=launch | anything else=no) ? "
if [ -z $REPLY ] ; then
	REPLY="no"
fi
if [ ${REPLY} = "yes" ] ; then
	TRASH=`launchctl unload /Library/LaunchDaemons/local.upd_pf_from_http_log.plist`
	launchctl load -w /Library/LaunchDaemons/local.upd_pf_from_http_log.plist
	echo "mini_weblog_crawler launched"
	echo "The tiny private threat response is now activated and running."
else
	echo "mini_weblog_crawler not launched as per request."
	echo "Don't forget to launch manually by releasing the command mentioned above in 3)."
	echo "The tiny private threat response is now installed but needs to be actived manually."
fi

exit 0
